"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
const client_1 = require("@prisma/client");
const bcrypt = __importStar(require("bcrypt"));
const prisma = new client_1.PrismaClient();
async function main() {
    console.log('🌱 Seeding RBAC & hierarchy...');
    const roles = await Promise.all([
        prisma.role.upsert({
            where: { name: 'SUPER_ADMIN' },
            update: {},
            create: { name: 'SUPER_ADMIN', level: 100 },
        }),
        prisma.role.upsert({
            where: { name: 'HR_ADMIN' },
            update: {},
            create: { name: 'HR_ADMIN', level: 80 },
        }),
        prisma.role.upsert({
            where: { name: 'EXECUTIVE' },
            update: {},
            create: { name: 'EXECUTIVE', level: 70 },
        }),
        prisma.role.upsert({
            where: { name: 'MANAGER' },
            update: {},
            create: { name: 'MANAGER', level: 50 },
        }),
        prisma.role.upsert({
            where: { name: 'STAFF' },
            update: {},
            create: { name: 'STAFF', level: 10 },
        }),
    ]);
    const roleMap = Object.fromEntries(roles.map(r => [r.name, r]));
    const divisions = await Promise.all([
        prisma.division.upsert({
            where: { name: 'Finance' },
            update: {},
            create: { name: 'Finance' },
        }),
        prisma.division.upsert({
            where: { name: 'Technology' },
            update: {},
            create: { name: 'Technology' },
        }),
        prisma.division.upsert({
            where: { name: 'Human Capital' },
            update: {},
            create: { name: 'Human Capital' },
        }),
    ]);
    const divisionMap = Object.fromEntries(divisions.map(d => [d.name, d]));
    const password = await bcrypt.hash('Password123!', 10);
    const ceo = await prisma.user.upsert({
        where: { email: 'ceo@company.com' },
        update: {},
        create: {
            name: 'CEO',
            email: 'ceo@company.com',
            password,
            registerVia: 'manual',
            roleId: roleMap.SUPER_ADMIN.id,
        },
    });
    const cfo = await prisma.user.upsert({
        where: { email: 'cfo@company.com' },
        update: {},
        create: {
            name: 'CFO',
            email: 'cfo@company.com',
            password,
            registerVia: 'manual',
            roleId: roleMap.EXECUTIVE.id,
            divisionId: divisionMap.Finance.id,
            managerId: ceo.id,
        },
    });
    const cto = await prisma.user.upsert({
        where: { email: 'cto@company.com' },
        update: {},
        create: {
            name: 'CTO',
            email: 'cto@company.com',
            password,
            registerVia: 'manual',
            roleId: roleMap.EXECUTIVE.id,
            divisionId: divisionMap.Technology.id,
            managerId: ceo.id,
        },
    });
    const hr = await prisma.user.upsert({
        where: { email: 'hr@company.com' },
        update: {},
        create: {
            name: 'HR Admin',
            email: 'hr@company.com',
            password,
            registerVia: 'manual',
            roleId: roleMap.HR_ADMIN.id,
            divisionId: divisionMap['Human Capital'].id,
            managerId: ceo.id,
        },
    });
    const finManager = await prisma.user.upsert({
        where: { email: 'manager.finance@company.com' },
        update: {},
        create: {
            name: 'Finance Manager',
            email: 'manager.finance@company.com',
            password,
            registerVia: 'manual',
            roleId: roleMap.MANAGER.id,
            divisionId: divisionMap.Finance.id,
            managerId: cfo.id,
        },
    });
    await prisma.user.createMany({
        data: [
            {
                name: 'Finance Staff 1',
                email: 'staff1.finance@company.com',
                registerVia: 'manual',
                password,
                roleId: roleMap.STAFF.id,
                divisionId: divisionMap.Finance.id,
                managerId: finManager.id,
            },
            {
                name: 'Finance Staff 2',
                email: 'staff2.finance@company.com',
                registerVia: 'manual',
                password,
                roleId: roleMap.STAFF.id,
                divisionId: divisionMap.Finance.id,
                managerId: finManager.id,
            },
        ],
        skipDuplicates: true,
    });
    console.log('✅ Seeding selesai');
}
main()
    .catch(e => {
    console.error(e);
    process.exit(1);
})
    .finally(async () => {
    await prisma.$disconnect();
});
//# sourceMappingURL=seed.js.map