"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ForgotPasswordUseCase = void 0;
const common_1 = require("@nestjs/common");
const email_service_1 = require("../../domain/services/email.service");
const dependency_injection_token_1 = require("../../domain/tokens/dependency.injection.token");
let ForgotPasswordUseCase = class ForgotPasswordUseCase {
    userRepo;
    tokenRepo;
    emailService;
    tokenGenerator;
    constructor(userRepo, tokenRepo, emailService, tokenGenerator) {
        this.userRepo = userRepo;
        this.tokenRepo = tokenRepo;
        this.emailService = emailService;
        this.tokenGenerator = tokenGenerator;
    }
    async execute(email) {
        const user = await this.userRepo.findByEmail(email);
        if (!user)
            return;
        const token = this.tokenGenerator.generate();
        await this.tokenRepo.create({
            id: this.tokenGenerator.generate(),
            userId: user.id,
            token,
            expiresAt: new Date(Date.now() + 15 * 60 * 1000),
            usedAt: null,
            createdAt: new Date(),
        });
        const resetLink = `http://localhost:3000/reset-password?token=${token}`;
        await this.emailService.sendForgotPasswordEmail(user.email, resetLink);
    }
};
exports.ForgotPasswordUseCase = ForgotPasswordUseCase;
exports.ForgotPasswordUseCase = ForgotPasswordUseCase = __decorate([
    __param(0, (0, common_1.Inject)(dependency_injection_token_1.USER_REPOSITORY)),
    __param(1, (0, common_1.Inject)(dependency_injection_token_1.PASSWORD_RESET_TOKEN_REPOSITORY)),
    __param(2, (0, common_1.Inject)(email_service_1.EmailService)),
    __param(3, (0, common_1.Inject)(dependency_injection_token_1.TOKEN_GENERATOR)),
    __metadata("design:paramtypes", [Object, Object, email_service_1.EmailService, Object])
], ForgotPasswordUseCase);
//# sourceMappingURL=forgot-password.usecase.js.map