"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetMeUseCase = void 0;
const common_1 = require("@nestjs/common");
const dependency_injection_token_1 = require("../../domain/tokens/dependency.injection.token");
const user_repository_1 = require("../../domain/repositories/user.repository");
let GetMeUseCase = class GetMeUseCase {
    userRepo;
    constructor(userRepo) {
        this.userRepo = userRepo;
    }
    async execute(userId) {
        const user = await this.userRepo.findById(userId);
        if (!user)
            return null;
        return {
            id: user.id,
            name: user.name,
            email: user.email,
        };
    }
};
exports.GetMeUseCase = GetMeUseCase;
exports.GetMeUseCase = GetMeUseCase = __decorate([
    __param(0, (0, common_1.Inject)(dependency_injection_token_1.USER_REPOSITORY)),
    __metadata("design:paramtypes", [user_repository_1.UserRepository])
], GetMeUseCase);
//# sourceMappingURL=get-me.usecase.js.map