import { UserRepository } from '@/domain/repositories/user.repository';
import type { PasswordHasher } from '@/domain/services/password-hasher.service';
import type { AuthTokenService } from '@/domain/services/auth-token.service';
import { RefreshTokenRepository } from '@/domain/repositories/refresh-token.repository';
export declare class LoginUserUseCase {
    private readonly userRepo;
    private readonly hasher;
    private readonly tokenService;
    private readonly refreshTokenRepo;
    constructor(userRepo: UserRepository, hasher: PasswordHasher, tokenService: AuthTokenService, refreshTokenRepo: RefreshTokenRepository);
    execute(email: string, password: string): Promise<{
        accessToken: string;
        user: {
            id: number | undefined;
            name: string;
            email: string;
        };
        refreshToken: string;
    }>;
}
