"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LoginUserUseCase = void 0;
const common_1 = require("@nestjs/common");
const user_repository_1 = require("../../domain/repositories/user.repository");
const dependency_injection_token_1 = require("../../domain/tokens/dependency.injection.token");
const refresh_token_repository_1 = require("../../domain/repositories/refresh-token.repository");
const refresh_token_entity_1 = require("../../domain/entities/refresh-token.entity");
const crypto_1 = require("crypto");
let LoginUserUseCase = class LoginUserUseCase {
    userRepo;
    hasher;
    tokenService;
    refreshTokenRepo;
    constructor(userRepo, hasher, tokenService, refreshTokenRepo) {
        this.userRepo = userRepo;
        this.hasher = hasher;
        this.tokenService = tokenService;
        this.refreshTokenRepo = refreshTokenRepo;
    }
    async execute(email, password) {
        const user = await this.userRepo.findByEmail(email);
        if (!user) {
            throw new common_1.HttpException('Email/Password salah', common_1.HttpStatus.BAD_REQUEST);
        }
        console.log('debug_fandy:loginUseCase >> user:', user.role?.name);
        const isValid = await this.hasher.compare(password, user.password);
        if (!isValid) {
            throw new common_1.HttpException('Email/Password salah', common_1.HttpStatus.BAD_REQUEST);
        }
        const isUserActivated = user.isEmailVerified == true ? true : false;
        if (!isUserActivated) {
            throw new common_1.HttpException('User belum aktif', common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
        const payload = {
            userId: user.id,
            email: user.email,
            name: user.name,
            role: {
                id: user.role?.id || undefined,
                name: user.role?.name || undefined,
                level: user.role?.level || undefined,
            },
            division: {
                id: user.division?.id || undefined,
                name: user.division?.name || undefined,
            },
        };
        const accessToken = await this.tokenService.generateAccessToken(payload);
        const refreshTokenValue = await this.tokenService.generateRefreshToken();
        const refreshToken = new refresh_token_entity_1.RefreshTokenEntity((0, crypto_1.randomUUID)(), user.id ?? -1, refreshTokenValue, new Date(Date.now() + 1000 * 60 * 60 * 24 * 7), null, new Date());
        await this.refreshTokenRepo.create(refreshToken);
        return {
            accessToken,
            user: {
                id: user.id,
                name: user.name,
                email: user.email,
            },
            refreshToken: refreshTokenValue
        };
    }
};
exports.LoginUserUseCase = LoginUserUseCase;
exports.LoginUserUseCase = LoginUserUseCase = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, common_1.Inject)(dependency_injection_token_1.USER_REPOSITORY)),
    __param(1, (0, common_1.Inject)(dependency_injection_token_1.PASSWORD_HASHER)),
    __param(2, (0, common_1.Inject)(dependency_injection_token_1.AUTH_TOKEN_SERVICE)),
    __param(3, (0, common_1.Inject)(dependency_injection_token_1.REFRESH_TOKEN_REPOSITORY)),
    __metadata("design:paramtypes", [user_repository_1.UserRepository, Object, Object, refresh_token_repository_1.RefreshTokenRepository])
], LoginUserUseCase);
//# sourceMappingURL=login-user.usecase.js.map