"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LogoutUseCase = void 0;
const common_1 = require("@nestjs/common");
const dependency_injection_token_1 = require("../../domain/tokens/dependency.injection.token");
const refresh_token_repository_1 = require("../../domain/repositories/refresh-token.repository");
let LogoutUseCase = class LogoutUseCase {
    refreshTokenRepo;
    constructor(refreshTokenRepo) {
        this.refreshTokenRepo = refreshTokenRepo;
    }
    async execute(refreshTokenValue) {
        const token = await this.refreshTokenRepo.findByToken(refreshTokenValue);
        if (!token) {
            return;
        }
        if (token.isRevoked()) {
            return;
        }
        await this.refreshTokenRepo.revoke(token.id);
    }
};
exports.LogoutUseCase = LogoutUseCase;
exports.LogoutUseCase = LogoutUseCase = __decorate([
    __param(0, (0, common_1.Inject)(dependency_injection_token_1.REFRESH_TOKEN_REPOSITORY)),
    __metadata("design:paramtypes", [refresh_token_repository_1.RefreshTokenRepository])
], LogoutUseCase);
//# sourceMappingURL=logout.usecase.js.map