"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.RefreshTokenUseCase = void 0;
const common_1 = require("@nestjs/common");
const refresh_token_repository_1 = require("../../domain/repositories/refresh-token.repository");
const dependency_injection_token_1 = require("../../domain/tokens/dependency.injection.token");
const refresh_token_entity_1 = require("../../domain/entities/refresh-token.entity");
const crypto_1 = require("crypto");
const prisma_user_repository_1 = require("../../infrastructure/database/repository/prisma.user.repository");
let RefreshTokenUseCase = class RefreshTokenUseCase {
    refreshTokenRepo;
    authTokenService;
    userRepository;
    constructor(refreshTokenRepo, authTokenService, userRepository) {
        this.refreshTokenRepo = refreshTokenRepo;
        this.authTokenService = authTokenService;
        this.userRepository = userRepository;
    }
    async execute(refreshToken) {
        const storedToken = await this.refreshTokenRepo.findByToken(refreshToken);
        if (!storedToken) {
            throw new common_1.HttpException('Refresh token tidak valid', common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
        if (storedToken.isExpired() || storedToken.isRevoked()) {
            throw new common_1.HttpException('Refresh token tidak berlaku', common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
        await this.refreshTokenRepo.revoke(storedToken.id);
        const newRefreshTokenValue = await this.authTokenService.generateRefreshToken();
        const newRefreshToken = new refresh_token_entity_1.RefreshTokenEntity((0, crypto_1.randomUUID)(), storedToken.userId, newRefreshTokenValue, new Date(Date.now() + 1000 * 60 * 60 * 24 * 7), null, new Date());
        await this.refreshTokenRepo.create(newRefreshToken);
        const user = await this.userRepository.findByIdWithRoleAndDivision(storedToken.userId);
        const payload = {
            userId: user.id,
            email: user.email,
            name: user.name,
            role: user.role
                ? {
                    id: user.role.id,
                    name: user.role.name,
                    level: user.role.level,
                }
                : undefined,
            division: user.division
                ? {
                    id: user.division.id,
                    name: user.division.name,
                }
                : undefined,
        };
        const newAccessToken = await this.authTokenService.generateAccessToken(payload);
        return {
            accessToken: newAccessToken,
            refreshToken: newRefreshTokenValue,
        };
    }
};
exports.RefreshTokenUseCase = RefreshTokenUseCase;
exports.RefreshTokenUseCase = RefreshTokenUseCase = __decorate([
    __param(0, (0, common_1.Inject)(dependency_injection_token_1.REFRESH_TOKEN_REPOSITORY)),
    __param(1, (0, common_1.Inject)(dependency_injection_token_1.AUTH_TOKEN_SERVICE)),
    __param(2, (0, common_1.Inject)(dependency_injection_token_1.USER_REPOSITORY)),
    __metadata("design:paramtypes", [refresh_token_repository_1.RefreshTokenRepository, Object, prisma_user_repository_1.PrismaUserRepository])
], RefreshTokenUseCase);
//# sourceMappingURL=refresh-token.usecase.js.map