import { UserRepository } from '@/domain/repositories/user.repository';
import { RegisterUserDto } from '@/application/dto/register-user.dto';
import type { PasswordHasher } from '@/domain/services/password-hasher.service';
import { EmailVerificationTokenRepository } from '@/domain/repositories/email-verification-token.repository';
import type { TokenGeneratorService } from '@/domain/services/token-generator.service';
import { EmailService } from '@/domain/services/email.service';
export declare class RegisterUserUseCase {
    private readonly userRepo;
    private readonly hasher;
    private readonly emailVerificationTokenRepo;
    private readonly tokenGeneratorService;
    private readonly emailService;
    constructor(userRepo: UserRepository, hasher: PasswordHasher, emailVerificationTokenRepo: EmailVerificationTokenRepository, tokenGeneratorService: TokenGeneratorService, emailService: EmailService);
    registerAndActivate(data: RegisterUserDto): Promise<any>;
    initiateRegister(data: RegisterUserDto): Promise<any>;
    verifyEmailRegister(registrationToken: string): Promise<any>;
}
