"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.RegisterUserUseCase = void 0;
const common_1 = require("@nestjs/common");
const user_repository_1 = require("../../domain/repositories/user.repository");
const user_entity_1 = require("../../domain/entities/user.entity");
const dependency_injection_token_1 = require("../../domain/tokens/dependency.injection.token");
const dependency_injection_token_2 = require("../../domain/tokens/dependency.injection.token");
const email_verification_token_repository_1 = require("../../domain/repositories/email-verification-token.repository");
const email_service_1 = require("../../domain/services/email.service");
let RegisterUserUseCase = class RegisterUserUseCase {
    userRepo;
    hasher;
    emailVerificationTokenRepo;
    tokenGeneratorService;
    emailService;
    constructor(userRepo, hasher, emailVerificationTokenRepo, tokenGeneratorService, emailService) {
        this.userRepo = userRepo;
        this.hasher = hasher;
        this.emailVerificationTokenRepo = emailVerificationTokenRepo;
        this.tokenGeneratorService = tokenGeneratorService;
        this.emailService = emailService;
    }
    async registerAndActivate(data) {
        const exists = await this.userRepo.findByEmail(data.email);
        if (exists) {
            throw new common_1.HttpException('Email sudah terdaftar', common_1.HttpStatus.BAD_REQUEST);
        }
        const hashed = await this.hasher.hash(data.password);
        const user = new user_entity_1.UserEntity({
            name: data.name,
            email: data.email,
            phoneNumber: data.phoneNumber,
            registerVia: data.registerVia,
            password: hashed,
            isEmailVerified: true,
        });
        const createdUser = await this.userRepo.create(user);
        return {
            id: createdUser.id,
            name: createdUser.name,
            email: createdUser.email,
        };
    }
    async initiateRegister(data) {
        const exists = await this.userRepo.findByEmail(data.email);
        if (exists) {
            throw new common_1.HttpException('Email sudah terdaftar', common_1.HttpStatus.BAD_REQUEST);
        }
        const hashed = await this.hasher.hash(data.password);
        const user = new user_entity_1.UserEntity({
            name: data.name,
            email: data.email,
            phoneNumber: data.phoneNumber,
            registerVia: data.registerVia,
            password: hashed,
            isEmailVerified: false,
        });
        const createdUser = await this.userRepo.create(user);
        if (!createdUser.id) {
            throw new common_1.HttpException('Terjadi kesalahan saat proses membuat akun saat register', common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
        const token = this.tokenGeneratorService.generate();
        this.emailVerificationTokenRepo.create({
            userId: createdUser.id,
            token: token,
            expiresAt: new Date(Date.now() + 15 * 60 * 1000),
        });
        const confirmRegistrationLink = `http://localhost:3000/confirm-registration?token=${token}`;
        await this.emailService.sendRegistrationConfirmationEmail(user.email, confirmRegistrationLink);
    }
    async verifyEmailRegister(registrationToken) {
        const dataRegisToken = await this.emailVerificationTokenRepo.findByToken(registrationToken);
        if (!dataRegisToken?.userId)
            throw new common_1.HttpException('Something wrong. Id not found', common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        console.log("debug_fandy_6jan >> userId FIRST: ", dataRegisToken.userId);
        await this.userRepo.markEmailAsVerified(dataRegisToken.userId);
        await this.emailVerificationTokenRepo.deleteByUserId(dataRegisToken.userId);
        console.log("debug_fandy_6jan >> userId LAST: ", dataRegisToken.userId);
        const user = await this.userRepo.findById(dataRegisToken.userId);
        return {
            id: user?.id,
            name: user?.name,
            email: user?.email,
        };
    }
};
exports.RegisterUserUseCase = RegisterUserUseCase;
exports.RegisterUserUseCase = RegisterUserUseCase = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, common_1.Inject)(dependency_injection_token_2.USER_REPOSITORY)),
    __param(1, (0, common_1.Inject)(dependency_injection_token_1.PASSWORD_HASHER)),
    __param(2, (0, common_1.Inject)(dependency_injection_token_1.EMAIL_VERIFICATION_TOKEN_REPOSITORY)),
    __param(3, (0, common_1.Inject)(dependency_injection_token_1.TOKEN_GENERATOR)),
    __param(4, (0, common_1.Inject)(email_service_1.EmailService)),
    __metadata("design:paramtypes", [user_repository_1.UserRepository, Object, email_verification_token_repository_1.EmailVerificationTokenRepository, Object, email_service_1.EmailService])
], RegisterUserUseCase);
//# sourceMappingURL=register-user.usecase.js.map