"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ResetPasswordUseCase = void 0;
const common_1 = require("@nestjs/common");
const dependency_injection_token_1 = require("../../domain/tokens/dependency.injection.token");
const password_reset_token_repository_1 = require("../../domain/repositories/password-reset-token.repository");
let ResetPasswordUseCase = class ResetPasswordUseCase {
    userRepo;
    tokenRepo;
    passwordHasher;
    constructor(userRepo, tokenRepo, passwordHasher) {
        this.userRepo = userRepo;
        this.tokenRepo = tokenRepo;
        this.passwordHasher = passwordHasher;
    }
    async execute(tokenValue, newPassword) {
        const token = await this.tokenRepo.findByToken(tokenValue);
        if (!token) {
            throw new common_1.HttpException('Reset Token Invalid', common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
        if (token.isExpired()) {
            throw new common_1.HttpException('Reset Token Expired', common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
        if (token.isUsed()) {
            throw new common_1.HttpException('Reset Token Already used', common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
        const hashedPassword = await this.passwordHasher.hash(newPassword);
        await this.userRepo.updatePassword(token.userId, hashedPassword);
        await this.tokenRepo.markAsUsed(token.id);
    }
};
exports.ResetPasswordUseCase = ResetPasswordUseCase;
exports.ResetPasswordUseCase = ResetPasswordUseCase = __decorate([
    __param(0, (0, common_1.Inject)(dependency_injection_token_1.USER_REPOSITORY)),
    __param(1, (0, common_1.Inject)(dependency_injection_token_1.PASSWORD_RESET_TOKEN_REPOSITORY)),
    __param(2, (0, common_1.Inject)(dependency_injection_token_1.PASSWORD_HASHER)),
    __metadata("design:paramtypes", [Object, password_reset_token_repository_1.PasswordResetTokenRepository, Object])
], ResetPasswordUseCase);
//# sourceMappingURL=reset-password.usecase.js.map