export declare abstract class EmailVerificationTokenRepository {
    abstract create(params: {
        userId: number;
        token: string;
        expiresAt: Date;
    }): Promise<void>;
    abstract findByToken(token: string): Promise<{
        id: number;
        userId: number;
        expiresAt: Date;
    } | null>;
    abstract deleteByUserId(userId: number): Promise<void>;
}
