import { UserEntity } from "../entities/user.entity";
export declare abstract class UserRepository {
    abstract create(user: UserEntity): Promise<UserEntity>;
    abstract findByEmail(email: string): Promise<UserEntity | null>;
    abstract findById(id: number): Promise<UserEntity | null>;
    abstract updatePassword(userId: number, hashedPassword: string): Promise<void>;
    abstract findByIdWithRoleAndDivision(id: number): Promise<UserEntity | null>;
    abstract markEmailAsVerified(userId: number): Promise<any>;
}
