export interface AuthTokenPayload {
    userId: number;
    email: string;
    name: string;
    role?: {
        id?: number;
        name?: string;
        level?: number;
    };
    division?: {
        id?: number;
        name?: string;
    };
}
export interface AuthTokenService {
    generateAccessToken(payload: AuthTokenPayload): Promise<string>;
    verifyAccessToken(token: string): Promise<AuthTokenPayload>;
    generateRefreshToken(): Promise<string>;
}
