import { PrismaService } from '../prisma/prisma.service';
import { EmailVerificationTokenRepository } from '@/domain/repositories/email-verification-token.repository';
export declare class PrismaEmailVerificationTokenRepository implements EmailVerificationTokenRepository {
    private readonly prisma;
    constructor(prisma: PrismaService);
    create(params: {
        userId: number;
        token: string;
        expiresAt: Date;
    }): Promise<void>;
    findByToken(token: string): Promise<{
        id: number;
        userId: number;
        expiresAt: Date;
    } | null>;
    deleteByUserId(userId: number): Promise<void>;
}
