"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PrismaEmailVerificationTokenRepository = void 0;
const common_1 = require("@nestjs/common");
const prisma_service_1 = require("../prisma/prisma.service");
let PrismaEmailVerificationTokenRepository = class PrismaEmailVerificationTokenRepository {
    prisma;
    constructor(prisma) {
        this.prisma = prisma;
    }
    async create(params) {
        await this.prisma.emailVerificationToken.create({
            data: {
                userId: params.userId,
                token: params.token,
                expiresAt: params.expiresAt,
            },
        });
    }
    async findByToken(token) {
        return this.prisma.emailVerificationToken.findUnique({
            where: { token },
            select: {
                id: true,
                userId: true,
                expiresAt: true,
            },
        });
    }
    async deleteByUserId(userId) {
        await this.prisma.emailVerificationToken.deleteMany({
            where: { userId },
        });
    }
};
exports.PrismaEmailVerificationTokenRepository = PrismaEmailVerificationTokenRepository;
exports.PrismaEmailVerificationTokenRepository = PrismaEmailVerificationTokenRepository = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [prisma_service_1.PrismaService])
], PrismaEmailVerificationTokenRepository);
//# sourceMappingURL=prisma.email-verification-token.repository.js.map