import { PrismaService } from '../prisma/prisma.service';
import { PasswordResetTokenRepository } from '@/domain/repositories/password-reset-token.repository';
import { PasswordResetTokenEntity } from '@/domain/entities/password-reset-token.entity';
export declare class PrismaPasswordResetTokenRepository implements PasswordResetTokenRepository {
    private readonly prisma;
    constructor(prisma: PrismaService);
    create(token: PasswordResetTokenEntity): Promise<void>;
    findByToken(token: string): Promise<PasswordResetTokenEntity | null>;
    markAsUsed(id: string): Promise<void>;
}
