"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PrismaPasswordResetTokenRepository = void 0;
const prisma_service_1 = require("../prisma/prisma.service");
const password_reset_token_entity_1 = require("../../../domain/entities/password-reset-token.entity");
const common_1 = require("@nestjs/common");
let PrismaPasswordResetTokenRepository = class PrismaPasswordResetTokenRepository {
    prisma;
    constructor(prisma) {
        this.prisma = prisma;
    }
    async create(token) {
        await this.prisma.passwordResetToken.create({
            data: {
                id: token.id,
                userId: token.userId,
                token: token.token,
                expiresAt: token.expiresAt,
                usedAt: token.usedAt,
            },
        });
    }
    async findByToken(token) {
        const data = await this.prisma.passwordResetToken.findUnique({
            where: { token },
        });
        if (!data)
            return null;
        return new password_reset_token_entity_1.PasswordResetTokenEntity(data.id, data.userId, data.token, data.expiresAt, data.usedAt, data.createdAt);
    }
    async markAsUsed(id) {
        await this.prisma.passwordResetToken.update({
            where: { id },
            data: { usedAt: new Date() },
        });
    }
};
exports.PrismaPasswordResetTokenRepository = PrismaPasswordResetTokenRepository;
exports.PrismaPasswordResetTokenRepository = PrismaPasswordResetTokenRepository = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [prisma_service_1.PrismaService])
], PrismaPasswordResetTokenRepository);
//# sourceMappingURL=prisma.password-reset-token.repository.js.map