"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PrismaRefreshTokenRepository = void 0;
const common_1 = require("@nestjs/common");
const prisma_service_1 = require("../prisma/prisma.service");
const refresh_token_entity_1 = require("../../../domain/entities/refresh-token.entity");
let PrismaRefreshTokenRepository = class PrismaRefreshTokenRepository {
    prisma;
    constructor(prisma) {
        this.prisma = prisma;
    }
    async create(token) {
        await this.prisma.refreshToken.create({
            data: {
                id: token.id,
                userId: token.userId,
                token: token.token,
                expiresAt: token.expiresAt,
                revokedAt: token.revokedAt,
            },
        });
    }
    async findByToken(token) {
        const data = await this.prisma.refreshToken.findUnique({
            where: { token },
        });
        if (!data)
            return null;
        return new refresh_token_entity_1.RefreshTokenEntity(data.id, data.userId, data.token, data.expiresAt, data.revokedAt, data.createdAt);
    }
    async revoke(tokenId) {
        await this.prisma.refreshToken.update({
            where: { id: tokenId },
            data: { revokedAt: new Date() },
        });
    }
};
exports.PrismaRefreshTokenRepository = PrismaRefreshTokenRepository;
exports.PrismaRefreshTokenRepository = PrismaRefreshTokenRepository = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [prisma_service_1.PrismaService])
], PrismaRefreshTokenRepository);
//# sourceMappingURL=prisma.refresh-token.repository.js.map