import { PrismaService } from '../prisma/prisma.service';
import { UserEntity } from '@/domain/entities/user.entity';
import { UserRepository } from '@/domain/repositories/user.repository';
export declare class PrismaUserRepository implements UserRepository {
    private readonly prisma;
    constructor(prisma: PrismaService);
    markEmailAsVerified(userId: number): Promise<any>;
    create(user: UserEntity): Promise<any>;
    findByEmail(email: string): Promise<any>;
    findById(id: number): Promise<any>;
    updatePassword(userId: number, hashedPassword: string): Promise<void>;
    findByIdWithRoleAndDivision(id: number): Promise<any>;
}
