"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PrismaUserRepository = void 0;
const common_1 = require("@nestjs/common");
const prisma_service_1 = require("../prisma/prisma.service");
let PrismaUserRepository = class PrismaUserRepository {
    prisma;
    constructor(prisma) {
        this.prisma = prisma;
    }
    markEmailAsVerified(userId) {
        return this.prisma.user.update({
            where: { id: userId },
            data: { isEmailVerified: true },
        });
    }
    async create(user) {
        return this.prisma.user.create({
            data: {
                name: user.name,
                email: user.email,
                phoneNumber: user.phoneNumber,
                registerVia: user.registerVia,
                password: user.password,
                isEmailVerified: user.isEmailVerified,
                roleId: 4,
                divisionId: 1
            },
        });
    }
    async findByEmail(email) {
        const result = this.prisma.user.findUnique({
            where: { email },
            include: {
                division: {
                    select: {
                        id: true,
                        name: true,
                    },
                },
                role: {
                    select: {
                        id: true,
                        name: true,
                        level: true,
                    },
                },
            },
        });
        return result;
    }
    async findById(id) {
        return this.prisma.user.findUnique({
            where: { id },
            include: {
                division: {
                    select: {
                        id: true,
                        name: true,
                    },
                },
                role: {
                    select: {
                        id: true,
                        name: true,
                        level: true,
                    },
                },
            },
        });
    }
    async updatePassword(userId, hashedPassword) {
        await this.prisma.user.update({
            where: { id: userId },
            data: {
                password: hashedPassword,
            },
        });
    }
    async findByIdWithRoleAndDivision(id) {
        return this.prisma.user.findUnique({
            where: { id },
            include: {
                role: {
                    select: {
                        id: true,
                        name: true,
                        level: true,
                    },
                },
                division: {
                    select: {
                        id: true,
                        name: true,
                    },
                },
            },
        });
    }
};
exports.PrismaUserRepository = PrismaUserRepository;
exports.PrismaUserRepository = PrismaUserRepository = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [prisma_service_1.PrismaService])
], PrismaUserRepository);
//# sourceMappingURL=prisma.user.repository.js.map