"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.EtherealEmailService = void 0;
const nodemailer_1 = __importDefault(require("nodemailer"));
class EtherealEmailService {
    async sendRegistrationConfirmationEmail(to, confirmationRegistrationLink) {
        const account = await nodemailer_1.default.createTestAccount();
        const transporter = nodemailer_1.default.createTransport({
            host: account.smtp.host,
            port: account.smtp.port,
            secure: account.smtp.secure,
            auth: {
                user: account.user,
                pass: account.pass,
            },
        });
        const info = await transporter.sendMail({
            from: '"HRIS DEV" <no-reply@hris.dev>',
            to,
            subject: 'Konfirmasi Registrasi',
            html: `<p>Klik link berikut untuk mengkonfirmasi pendaftaran kamu:</p><a href="${confirmationRegistrationLink}">${confirmationRegistrationLink}</a>`,
        });
        console.log('📧 Email preview:', nodemailer_1.default.getTestMessageUrl(info));
    }
    async sendForgotPasswordEmail(to, resetLink) {
        const account = await nodemailer_1.default.createTestAccount();
        const transporter = nodemailer_1.default.createTransport({
            host: account.smtp.host,
            port: account.smtp.port,
            secure: account.smtp.secure,
            auth: {
                user: account.user,
                pass: account.pass,
            },
        });
        const info = await transporter.sendMail({
            from: '"HRIS DEV" <no-reply@hris.dev>',
            to,
            subject: 'Reset Password',
            html: `<p>Klik link berikut:</p><a href="${resetLink}">${resetLink}</a>`,
        });
        console.log('📧 Email preview:', nodemailer_1.default.getTestMessageUrl(info));
    }
}
exports.EtherealEmailService = EtherealEmailService;
//# sourceMappingURL=ethereal-email.service.js.map