"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthModule = void 0;
const common_1 = require("@nestjs/common");
const auth_controller_1 = require("./controllers/auth.controller");
const register_user_usecase_1 = require("../../application/use-cases/register-user.usecase");
const login_user_usecase_1 = require("../../application/use-cases/login-user.usecase");
const logout_usecase_1 = require("../../application/use-cases/logout.usecase");
const dependency_injection_token_1 = require("../../domain/tokens/dependency.injection.token");
const prisma_user_repository_1 = require("../database/repository/prisma.user.repository");
const bcrypt_password_hasher_1 = require("../security/bcrypt-password-hasher");
const jwt_auth_token_1 = require("../security/jwt-auth-token");
const prisma_refresh_token_repository_1 = require("../database/repository/prisma.refresh-token.repository");
const prisma_module_1 = require("../database/prisma/prisma.module");
const get_me_usecase_1 = require("../../application/use-cases/get-me.usecase");
const jwt_auth_guards_1 = require("./guards/jwt.auth.guards");
const dependency_injection_token_2 = require("../../domain/tokens/dependency.injection.token");
const refresh_token_usecase_1 = require("../../application/use-cases/refresh-token.usecase");
const forgot_password_usecase_1 = require("../../application/use-cases/forgot-password.usecase");
const email_service_1 = require("../../domain/services/email.service");
const ethereal_email_service_1 = require("../email/ethereal-email.service");
const prisma_password_reset_token_repository_1 = require("../database/repository/prisma.password-reset-token.repository");
const reset_password_usecase_1 = require("../../application/use-cases/reset-password.usecase");
const rbac_guard_1 = require("./guards/rbac.guard");
const rbac_controller_1 = require("./controllers/rbac.controller");
const uuid_token_generator_1 = require("../security/uuid-token-generator");
const prisma_email_verification_token_repository_1 = require("../database/repository/prisma.email-verification-token.repository");
let AuthModule = class AuthModule {
};
exports.AuthModule = AuthModule;
exports.AuthModule = AuthModule = __decorate([
    (0, common_1.Module)({
        imports: [
            prisma_module_1.PrismaModule,
        ],
        controllers: [
            auth_controller_1.AuthController,
            rbac_controller_1.RbacController,
        ],
        providers: [
            jwt_auth_guards_1.JwtAuthGuard,
            rbac_guard_1.RbacGuard,
            register_user_usecase_1.RegisterUserUseCase,
            login_user_usecase_1.LoginUserUseCase,
            get_me_usecase_1.GetMeUseCase,
            refresh_token_usecase_1.RefreshTokenUseCase,
            logout_usecase_1.LogoutUseCase,
            forgot_password_usecase_1.ForgotPasswordUseCase,
            reset_password_usecase_1.ResetPasswordUseCase,
            {
                provide: dependency_injection_token_1.PASSWORD_HASHER,
                useClass: bcrypt_password_hasher_1.BcryptPasswordHasher,
            },
            {
                provide: dependency_injection_token_1.AUTH_TOKEN_SERVICE,
                useClass: jwt_auth_token_1.JwtAuthToken,
            },
            {
                provide: dependency_injection_token_2.USER_REPOSITORY,
                useClass: prisma_user_repository_1.PrismaUserRepository,
            },
            {
                provide: dependency_injection_token_1.REFRESH_TOKEN_REPOSITORY,
                useClass: prisma_refresh_token_repository_1.PrismaRefreshTokenRepository,
            },
            {
                provide: email_service_1.EmailService,
                useClass: ethereal_email_service_1.EtherealEmailService,
            },
            {
                provide: dependency_injection_token_1.PASSWORD_RESET_TOKEN_REPOSITORY,
                useClass: prisma_password_reset_token_repository_1.PrismaPasswordResetTokenRepository,
            },
            {
                provide: dependency_injection_token_1.TOKEN_GENERATOR,
                useClass: uuid_token_generator_1.UuidTokenGenerator,
            },
            {
                provide: dependency_injection_token_1.EMAIL_VERIFICATION_TOKEN_REPOSITORY,
                useClass: prisma_email_verification_token_repository_1.PrismaEmailVerificationTokenRepository,
            },
        ],
    })
], AuthModule);
//# sourceMappingURL=auth.module.js.map