import type { FastifyRequest } from 'fastify';
import { RegisterUserHttpDto } from '../dto/register-user.http.dto';
import { RegisterUserUseCase } from '@/application/use-cases/register-user.usecase';
import { LoginUserUseCase } from '@/application/use-cases/login-user.usecase';
import { GetMeUseCase } from '@/application/use-cases/get-me.usecase';
import { RefreshTokenUseCase } from '@/application/use-cases/refresh-token.usecase';
import type { FastifyReply } from 'fastify';
import { LogoutUseCase } from '@/application/use-cases/logout.usecase';
import { ForgotPasswordUseCase } from '@/application/use-cases/forgot-password.usecase';
import { ResetPasswordUseCase } from '@/application/use-cases/reset-password.usecase';
export declare class AuthController {
    private readonly registerUserUseCase;
    private readonly loginUserUseCase;
    private readonly getMe;
    private readonly refreshTokenUseCase;
    private readonly logoutUseCase;
    private readonly forgotPasswordUseCase;
    private readonly resetPasswordUseCase;
    constructor(registerUserUseCase: RegisterUserUseCase, loginUserUseCase: LoginUserUseCase, getMe: GetMeUseCase, refreshTokenUseCase: RefreshTokenUseCase, logoutUseCase: LogoutUseCase, forgotPasswordUseCase: ForgotPasswordUseCase, resetPasswordUseCase: ResetPasswordUseCase);
    register(body: RegisterUserHttpDto): Promise<{
        message: string;
        data: any;
    }>;
    login(body: {
        email: string;
        password: string;
    }, res: FastifyReply): Promise<{
        accessToken: string;
        user: {
            id: number | undefined;
            name: string;
            email: string;
        };
    }>;
    me(user: {
        id: number;
    }): Promise<Partial<import("../../../domain/entities/user.entity").UserEntity> | null>;
    refresh(request: FastifyRequest, res: FastifyReply): Promise<{
        accessToken: any;
    }>;
    logout(request: FastifyRequest, res: FastifyReply): Promise<{
        message: string;
    }>;
    forgotPassword(email: string): Promise<{
        message: string;
    }>;
    resetPassword(body: {
        token: string;
        newPassword: string;
    }): Promise<{
        message: string;
    }>;
    verifyEmail(token: string): Promise<{
        message: string;
        data: any;
    }>;
}
