"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthController = void 0;
const common_1 = require("@nestjs/common");
const register_user_http_dto_1 = require("../dto/register-user.http.dto");
const register_user_usecase_1 = require("../../../application/use-cases/register-user.usecase");
const domain_error_1 = require("../../../domain/errors/domain.error");
const login_user_usecase_1 = require("../../../application/use-cases/login-user.usecase");
const jwt_auth_guards_1 = require("../guards/jwt.auth.guards");
const current_user_decorator_1 = require("../decorators/current-user.decorator");
const get_me_usecase_1 = require("../../../application/use-cases/get-me.usecase");
const refresh_token_usecase_1 = require("../../../application/use-cases/refresh-token.usecase");
const logout_usecase_1 = require("../../../application/use-cases/logout.usecase");
const forgot_password_usecase_1 = require("../../../application/use-cases/forgot-password.usecase");
const reset_password_usecase_1 = require("../../../application/use-cases/reset-password.usecase");
let AuthController = class AuthController {
    registerUserUseCase;
    loginUserUseCase;
    getMe;
    refreshTokenUseCase;
    logoutUseCase;
    forgotPasswordUseCase;
    resetPasswordUseCase;
    constructor(registerUserUseCase, loginUserUseCase, getMe, refreshTokenUseCase, logoutUseCase, forgotPasswordUseCase, resetPasswordUseCase) {
        this.registerUserUseCase = registerUserUseCase;
        this.loginUserUseCase = loginUserUseCase;
        this.getMe = getMe;
        this.refreshTokenUseCase = refreshTokenUseCase;
        this.logoutUseCase = logoutUseCase;
        this.forgotPasswordUseCase = forgotPasswordUseCase;
        this.resetPasswordUseCase = resetPasswordUseCase;
    }
    async register(body) {
        const dto = {
            name: body.name,
            email: body.email,
            password: body.password,
            phoneNumber: body.phoneNumber,
            registerVia: body.registerVia
        };
        try {
            const result = await this.registerUserUseCase.registerAndActivate(dto);
            return {
                message: 'Register berhasil',
                data: result,
            };
        }
        catch (error) {
            if (error instanceof domain_error_1.DomainError) {
                switch (error.message) {
                    case 'EMAIL_ALREADY_EXISTS':
                        throw new common_1.HttpException('Email sudah terdaftar', common_1.HttpStatus.INTERNAL_SERVER_ERROR);
                    default:
                        throw new common_1.HttpException('Kesalahan bisnis yang tidak diketahui', common_1.HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
            throw error;
        }
    }
    async login(body, res) {
        const result = await this.loginUserUseCase.execute(body.email, body.password);
        const { refreshToken, ...responseBody } = result;
        res.setCookie('refresh_token', result.refreshToken, {
            httpOnly: true,
            secure: process.env.NODE_ENV === 'production',
            sameSite: 'lax',
            path: '/',
            maxAge: 60 * 60 * 24 * 7,
        });
        return responseBody;
    }
    async me(user) {
        return this.getMe.execute(user.id);
    }
    async refresh(request, res) {
        console.log('COOKIES MASUK:', request.cookies?.refresh_token);
        const refreshTokenFromFE = request.cookies?.refresh_token || request.headers['authorization']?.replace('Bearer ', '');
        if (!refreshTokenFromFE) {
            throw new common_1.HttpException('Refresh token tidak ditemukan', common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
        const result = await this.refreshTokenUseCase.execute(refreshTokenFromFE);
        const { refreshToken, ...responseBody } = result;
        res.setCookie('refresh_token', result.refreshToken, {
            httpOnly: true,
            secure: process.env.NODE_ENV === 'production',
            sameSite: 'lax',
            path: '/',
            maxAge: 60 * 60 * 24 * 7,
        });
        return responseBody;
    }
    async logout(request, res) {
        const refreshToken = request.cookies?.refresh_token || request.headers['authorization']?.replace('Bearer ', '');
        if (refreshToken) {
            await this.logoutUseCase.execute(refreshToken);
        }
        res.clearCookie('refresh_token', {
            path: '/',
        });
        return {
            message: 'Logout berhasil',
        };
    }
    async forgotPassword(email) {
        await this.forgotPasswordUseCase.execute(email);
        return {
            message: 'Jika email terdaftar, instruksi reset telah dikirim',
        };
    }
    async resetPassword(body) {
        try {
            await this.resetPasswordUseCase.execute(body.token, body.newPassword);
            return {
                message: 'Password berhasil diubah',
            };
        }
        catch (error) {
            switch (error.message) {
                case 'RESET_TOKEN_INVALID':
                    throw new common_1.HttpException('Token reset tidak valid', common_1.HttpStatus.INTERNAL_SERVER_ERROR);
                case 'RESET_TOKEN_EXPIRED':
                    throw new common_1.HttpException('Token reset sudah expired', common_1.HttpStatus.INTERNAL_SERVER_ERROR);
                case 'RESET_TOKEN_ALREADY_USED':
                    throw new common_1.HttpException('Token reset sudah digunakan', common_1.HttpStatus.INTERNAL_SERVER_ERROR);
                default:
                    throw error;
            }
        }
    }
    async verifyEmail(token) {
        if (!token) {
            throw new common_1.HttpException('Token tidak ditemukan', common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
        const result = await this.registerUserUseCase.verifyEmailRegister(token);
        return {
            message: 'Register berhasil',
            data: result,
        };
    }
};
exports.AuthController = AuthController;
__decorate([
    (0, common_1.Post)('register'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [register_user_http_dto_1.RegisterUserHttpDto]),
    __metadata("design:returntype", Promise)
], AuthController.prototype, "register", null);
__decorate([
    (0, common_1.Post)('login'),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, common_1.Res)({ passthrough: true })),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", Promise)
], AuthController.prototype, "login", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guards_1.JwtAuthGuard),
    (0, common_1.Get)('me'),
    __param(0, (0, current_user_decorator_1.CurrentUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], AuthController.prototype, "me", null);
__decorate([
    (0, common_1.Post)('refresh'),
    __param(0, (0, common_1.Req)()),
    __param(1, (0, common_1.Res)({ passthrough: true })),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", Promise)
], AuthController.prototype, "refresh", null);
__decorate([
    (0, common_1.Post)('logout'),
    __param(0, (0, common_1.Req)()),
    __param(1, (0, common_1.Res)({ passthrough: true })),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", Promise)
], AuthController.prototype, "logout", null);
__decorate([
    (0, common_1.Post)('forgot-password'),
    __param(0, (0, common_1.Body)('email')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], AuthController.prototype, "forgotPassword", null);
__decorate([
    (0, common_1.Post)('reset-password'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], AuthController.prototype, "resetPassword", null);
__decorate([
    (0, common_1.Get)('verify-email'),
    __param(0, (0, common_1.Query)('token')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], AuthController.prototype, "verifyEmail", null);
exports.AuthController = AuthController = __decorate([
    (0, common_1.Controller)('auth'),
    __metadata("design:paramtypes", [register_user_usecase_1.RegisterUserUseCase,
        login_user_usecase_1.LoginUserUseCase,
        get_me_usecase_1.GetMeUseCase,
        refresh_token_usecase_1.RefreshTokenUseCase,
        logout_usecase_1.LogoutUseCase,
        forgot_password_usecase_1.ForgotPasswordUseCase,
        reset_password_usecase_1.ResetPasswordUseCase])
], AuthController);
//# sourceMappingURL=auth.controller.js.map