"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.RbacController = void 0;
const common_1 = require("@nestjs/common");
const jwt_auth_guards_1 = require("../guards/jwt.auth.guards");
const rbac_guard_1 = require("../guards/rbac.guard");
const roles_decorator_1 = require("../decorators/roles.decorator");
const roles_1 = require("../../../shared/constants/roles");
let RbacController = class RbacController {
    me() {
        return { message: 'Access ME allowed' };
    }
    team() {
        return { message: 'Access TEAM allowed' };
    }
    all() {
        return { message: 'Access ALL allowed' };
    }
};
exports.RbacController = RbacController;
__decorate([
    (0, common_1.Get)('me'),
    (0, roles_decorator_1.Roles)(roles_1.RoleName.STAFF, roles_1.RoleName.MANAGER, roles_1.RoleName.EXECUTIVE, roles_1.RoleName.HR_ADMIN, roles_1.RoleName.SUPER_ADMIN),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], RbacController.prototype, "me", null);
__decorate([
    (0, common_1.Get)('team'),
    (0, roles_decorator_1.Roles)(roles_1.RoleName.MANAGER, roles_1.RoleName.EXECUTIVE, roles_1.RoleName.HR_ADMIN, roles_1.RoleName.SUPER_ADMIN),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], RbacController.prototype, "team", null);
__decorate([
    (0, common_1.Get)('all'),
    (0, roles_decorator_1.Roles)(roles_1.RoleName.HR_ADMIN, roles_1.RoleName.SUPER_ADMIN),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], RbacController.prototype, "all", null);
exports.RbacController = RbacController = __decorate([
    (0, common_1.Controller)('rbac'),
    (0, common_1.UseGuards)(jwt_auth_guards_1.JwtAuthGuard, rbac_guard_1.RbacGuard)
], RbacController);
//# sourceMappingURL=rbac.controller.js.map