"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.JwtAuthGuard = void 0;
const common_1 = require("@nestjs/common");
const dependency_injection_token_1 = require("../../../domain/tokens/dependency.injection.token");
let JwtAuthGuard = class JwtAuthGuard {
    tokenService;
    constructor(tokenService) {
        this.tokenService = tokenService;
    }
    async canActivate(context) {
        const request = context
            .switchToHttp()
            .getRequest();
        const authHeader = request.headers['authorization'];
        if (!authHeader) {
            throw new common_1.UnauthorizedException('Token tidak ditemukan');
        }
        const [type, token] = authHeader.split(' ');
        if (type !== 'Bearer' || !token) {
            throw new common_1.UnauthorizedException('Format token tidak valid');
        }
        try {
            const payload = await this.tokenService.verifyAccessToken(token);
            console.log("debug_fandyxx >> token: ", token);
            console.log("debug_fandyxx >> payload: ", payload);
            request.user = {
                id: payload.userId,
                email: payload.email,
                role: {
                    id: payload.role?.id,
                    name: payload.role?.name,
                    level: payload.role?.level,
                },
                division: {
                    id: payload.division?.id,
                    name: payload.division?.name,
                },
            };
            return true;
        }
        catch {
            throw new common_1.UnauthorizedException('Token tidak valid');
        }
    }
};
exports.JwtAuthGuard = JwtAuthGuard;
exports.JwtAuthGuard = JwtAuthGuard = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, common_1.Inject)(dependency_injection_token_1.AUTH_TOKEN_SERVICE)),
    __metadata("design:paramtypes", [Object])
], JwtAuthGuard);
//# sourceMappingURL=jwt.auth.guards.js.map